<?php

require('client.inc.php');
//error_reporting(E_ALL);
//ini_set('display_errors', '1');
//ini_set('display_startup_errors', '1');

ini_set("allow_url_fopen", true);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: PUT');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Methods, Access-Control-Allow-Headers, Authorization, X-Requested-With');
// To update is similar to insert. Except in rest api update request is done throough PUT method


define("TOKEN","Gkbbb978@klwa-FFFF22323FFFgAeer**191");






$data = json_decode(file_get_contents("php://input"),true);


if(empty($data))
{
parse_str($_SERVER['QUERY_STRING'],$data);
}
$method = ""; 

if(isset($data['method']))
$method = $data['method'];

switch($method)
{
case "createTenant":
echo createtenant($data);
break;



case "createTicket":
echo createticket($data);
break;
case "createDept":
echo createdept($data);
break;
case "createStaff":
echo createstaff($data);
break;
case "createTeam":
echo createteam($data);
break;


case "updateTenant":
echo updatetenant($data);
break;

case "updateTicket":
echo updateticket($data);
break;
case "updateDept":
echo updatedept($data);
break;
case "updateStaff":
echo updatestaff($data);
break;
case "updateTeam":
echo updateteam($data);
break;


case "deleteTenant":
echo deletetenant($data);
break;

case "deleteTicket":
echo deleteticket($data);
break;
case "deleteStaff":
echo deletestaff($data);
break;
case "deleteDept":
echo deletedept($data);
break;
case "deleteTeam":
echo deleteteam($data);
break;
 default:
  echo json_encode(["msg"=>"Wrong Method!..Please input correct method"]);  
}


//ticket_id (integer): The ID of the ticket that is being deleted.



function deletetenant($data)
{
if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}

if( !isset($data['tenant_id']))
{
 return json_encode(['msg' => "tenant_id is required", 'status' => false]);
}
$id = Format::sanitize($data['tenant_id'],true);
$conn = new mysqli(DBHOST,DBUSER,DBPASS,DBNAME);
$db_query = "SELECT db_name from `sip`.`sites` where id = '$id'";
$r = mysqli_fetch_array(mysqli_query($conn,$db_query));
if(empty($r))
{
 return json_encode(['msg' => "Unable to fetch Database name from the given Tenant Id", 'status' => false]);

}
$db_name =$r[0];
if(!mysqli_query($conn,"DROP DATABASE {$db_name}"))
{
return json_encode(['msg' => "Unable to delete Database", 'status' => false]);

}
if(!mysqli_query($conn,"DELETE from `sip`.`sites` where id = '$id'"))
{
return json_encode(['msg' => "Unable to delete entry from sites table", 'status' => false]);

}

return json_encode(['msg' => "Deletion Successful", 'status' => true]);

}

function updatetenant($data)
{

if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}


if( !isset($data['tenant_id']))
{
 return json_encode(['msg' => "tenant_id is required", 'status' => false]);
}

if( !isset($data['url']) && !isset($data['name']))
{
 return json_encode(['msg' => "Either url or name is required parameters", 'status' => false]);
}
$conn = new mysqli(DBHOST,DBUSER,DBPASS,DBNAME);

$id = Format::sanitize($data['tenant_id'],true);
$url = Format::sanitize($data['url'],true);
$name = Format::sanitize($data['name'],true);
$updateq = "UPDATE `sip`.`sites` set site_name='$name',url='$url' where id = '$id'";
if(mysqli_query($conn,$updateq))
{
return json_encode(['msg' => "Updated Successfully", 'status' => true]);

}
else
{
return json_encode(['msg' => "Some error..Unable to update", 'status' => false]);

}


}



function createtenant($data)
{
#  DBHOST can have comma separated hosts (e.g db1:6033,db2:6033)
//define('DBHOST','localhost');
//define('DBNAME1','sip');
//define('DBUSER','sip');
//define('DBPASS','Sami@123');

if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}

if(!isset($data['host']) || !isset($data['dbuser']) || !isset($data['dbpass']) || !isset($data['dbname']) || !isset($data['url']) || !isset($data['name']))
{
 return json_encode(['msg' => "host,dbuser,dbpass,dbname,url,name are required parameters", 'status' => false]);
}
$url2 = $data['url'];
if(!strstr($url2,"http://"))
$url2 = "http://".$url2;
if (filter_var($url2, FILTER_VALIDATE_URL) === FALSE) {
 return json_encode(['msg' => "Not a valid Url", 'status' => false]);
}

$host = Format::sanitize($data['host'],true);
$dbuser = Format::sanitize($data['dbuser'],true);
$dbpass = Format::sanitize($data['dbpass'],true);
$sourceDbName = "osticket_base";
$destinationDbName = Format::sanitize($data['dbname'],true);
$url = Format::sanitize($data['url'],true);
$name = Format::sanitize($data['name'],true);

//$url = $_SERVER['SERVER_NAME'];




try 
{
$conn = new mysqli($host,$dbuser,$dbpass,$sourceDbName);
}
catch(Exception $ex)
{
 return json_encode(['msg' => "Unable to connect to source Database", 'status' => false]);
}

$tables = mysqli_query($conn,"SHOW TABLES");
 if(!$tables)
 {
 return json_encode(['msg' => "Unable to fetch tables of source DB", 'status' => false]);

 }


try
{
mysqli_query($conn,"USE {$destinationDbName}");
}
catch(Exception $ex)
{
 return json_encode(['msg' => "Unable to connect to destination Database", 'status' => false]);

}

while($rows = mysqli_fetch_array($tables))
{
	$tableName = $rows[0];
	$q = mysqli_query($conn,"SHOW CREATE TABLE `{$sourceDbName}`.`{$tableName}`");
	if(!$q)
	{
 	return json_encode(['msg' => mysqli_error($conn), 'status' => false]);

	}

	$r = mysqli_fetch_array($q);
//print_r($r);
	$createCommand = $r[1];
  	$carefulCreateCommand = str_replace("CREATE TABLE", "CREATE TABLE IF NOT EXISTS", $createCommand);
//print_r($carefulCreateCommand);
	if(!mysqli_query($conn,$carefulCreateCommand))
	{

 	return json_encode(['msg' => mysqli_error($conn), 'status' => false]);

	}



	if(! mysqli_query($conn,"INSERT INTO `{$destinationDbName}`.`{$tableName}` SELECT * FROM `{$sourceDbName}`.`{$tableName}`"))
	{
 	return json_encode(['msg' => mysqli_error($conn), 'status' => false]);
	}
  
}
if(!mysqli_query($conn,"INSERT INTO `sip`.`sites` set site_name='$name',url='$url',db_name='$destinationDbName'"))
{
	return json_encode(['msg' => "Datebase created but error in last step - entry in sites table", 'status' => false]);

}
return json_encode(['msg' =>mysqli_insert_id($conn), 'status' => true]);

}






function deleteticket($data)
{
    /* Required Parameters - ticket_id */

if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}


if(!isset($data['ticket_id']))
{
 return json_encode(['msg' => "ticket_id is required parameter", 'status' => false]);
}



    $ticket_id = $data['ticket_id'];
    $ticket = $user = null; 
    $ticket=Ticket::lookup($ticket_id);
//print_r($ticket);
if(!$ticket)
{
return json_encode(['msg' => "Ticket not found", 'status' => false]);
}
$resp = $ticket->delete();
    if($resp)
    {
    $status = true;
    $resp = "Success";
    }
    else 
    {
    $status = false;
    }
    return json_encode(['msg' => $resp, 'status' => $status]);

}





function deletedept($data)
{
/* Required Parameters - dept_id */

if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}

if(!isset($data['dept_id']))
{
 return json_encode(['msg' => "dept_id is required parameter", 'status' => false]);
}

    $dept_id = $data['dept_id'];
    $dept =Dept::lookup($dept_id);
   // $dept->id =$dept_id;
	if(!$dept)
    {
        return json_encode(['msg' => "Unable to find department", 'status' => $status]);

    }
    $resp = $dept->delete();
    
    /*if Response is 1 - deletion is successful 
    - if its 0 ,either its default department 
    or department has users so it cant be deleted
   */
    if($resp)
    {
    $status = true;
    $resp = "Success";
    }
    else 
    {
    $resp = "Failed - Unable to delete default department or if department has members";
    
    $status = false;
    }
    return json_encode(['msg' => $resp, 'status' => $status]);

}





function deletestaff($data)
{
/* Required Parameters - staff_id,user_id */

  if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}
 
    $staff_id = $data['staff_id'];
    
if(!isset($data['staff_id']))
{
 return json_encode(['msg' => "staff_id is required parameter", 'status' => false]);
}
    
if(!isset($data['user_id']))
{
 return json_encode(['msg' => "user_id is required parameter", 'status' => false]);
}
  $user_id = $data['user_id'];
  
global $thisstaff;
    $thisstaff = Staff::lookup($user_id);
  


	$staff =new Staff();
    $staff->staff_id =$staff_id;

    $resp = $staff->delete();
    if($resp)
    {
    $status = true;
    $resp = "Success";
    }
    else 
    {
    $resp = "Unable to delete or staff  not found";
    
    $status = false;
    }
    return json_encode(['msg' => $resp, 'status' => $status]);

}




function deleteteam($data)
{
/* Required Parameters - team_id,user_id */

  if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}
 
    $team_id = $data['team_id'];
    
if(!isset($data['team_id']))
{
 return json_encode(['msg' => "team_id is required parameter", 'status' => false]);
}
    
   

global $thisstaff;
    $thisstaff = true;

	$team =Team::lookup($team_id);
	if(!$team)
    {
        return json_encode(['msg' => "Unable to find Team", 'status' => $status]);

    }
$team->team_id = $team_id;	

$resp = $team->delete();
    if($resp)
    {
    $status = true;
    $resp = "Success";
    }
    else 
    {
    $resp = "Unable to delete or Team not found";
    $status = false;
    }
    return json_encode(['msg' => $resp, 'status' => $status]);

}


function createticket($data)
{
//error_reporting(E_ALL);
//ini_set('display_errors', '1');
//ini_set('display_startup_errors', '1');
/* Required Parameters - name,email or uid */
if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}

   
if(!isset($data['uid']))
{

    if(!(isset($data['email']) && isset($data['name'])))
{
    return json_encode(['msg' => "either uid or name and email are required", 'status' => false]);
}
}
$uid = $data['uid'];
    
    
if(!isset($data['message']))
{
 return json_encode(['msg' => "message is required parameter", 'status' => false]);
}
$name = $data['name'];
$email = $data['email'];

$subject = $data['subject'];

$message = $data['message'];
$deptId = $data['deptId'];
$topicId = $data['topicId'];
$duedate = $data['duedate'];
$note = $data['note'];
$response = $data['response'];
$assignId = $data['assignId'];



$uid = $data['uid'];

$files = $_FILES['files'];
//print_r($files);
$attachments = $data['attachments'];


if(!Dept::lookup($deptId)){
 return json_encode(['msg' => "Dept Not found", 'status' => false]);
}   
if(!Topic::lookup($topicId)){
 return json_encode(['msg' => "Topic Not found", 'status' => false]);
}   


  //  global $thisstaff;
   // $thisstaff = StaffAuthenticationBackend::getUser($user_id);

   $vars = array();
   $vars['email'] = $email;
   $vars['name'] = $name;
   $vars['subject'] = $subject;
   
   $vars['message'] = $message;
   $vars['uid'] = $uid;
   $vars['deptId']=$deptId;
   $vars['topicId'] = $topicId;
   $vars['duedate'] = $duedate;
   $vars['files'] = $files;
   $vars['attachments'] = $attachments;
   $vars['response'] = $response;
   $vars['note'] = $note;
$vars['assignId'] = $assignId;
   $errors = array();
   $ticket=Ticket::create($vars,$errors,"web",false,false);
	
    if($ticket)
    {
    $status = true;
    $resp = $ticket->ht['ticket_id'];
    }
    else 
    {
       // print_r($errors);

    ob_start();
print_r($errors);
$resp = ob_get_contents();;
ob_end_clean();
flush();
$status = false;

    }
    return json_encode(['msg' => $resp, 'status' => $status]);

}






function updateticket($data)
{
/* Required Parameters - name,email or uid */
if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}

    
if(!isset($data['user_id']))
{
 return json_encode(['msg' => "user_id is required parameter", 'status' => false]);
}
$user_id = $data['user_id'];



global $thisstaff;
    $thisstaff = Staff::lookup($user_id);
//  $thisstaff = StaffAuthenticationBackend::getUser();
  
//if(!$thisstaff)
{
 //return json_encode(['msg' => "Staff not authenticated to perform this operation", 'status' => false]);

}


$uid = $data['uid'];
    
    
if(!isset($data['ticket_id']))
{
 return json_encode(['msg' => "ticket_id is required parameter", 'status' => false]);
}
$name = $data['name'];
$email = $data['email'];

$subject = $data['subject'];

$message = $data['message'];
$deptId = $data['deptId'];
$topicId = $data['topicId'];
$duedate = $data['duedate'];
$note = $data['note'];
$response = $data['response'];
$assignId = $data['assignId'];
  
if(!Staff::lookup($assignId)){
 return json_encode(['msg' => "Staff Not found - assignId", 'status' => false]);
} 
  
if(!Dept::lookup($deptId)){
 return json_encode(['msg' => "Dept Not found", 'status' => false]);
}   
if(!Topic::lookup($topicId)){
 return json_encode(['msg' => "Topic Not found", 'status' => false]);
}   



   $vars = array();
   if(!empty($email))
	$vars['email'] = $email;
   if(!empty($name))
   $vars['name'] = $name;
   if(!empty($subject))
	$vars['subject'] = $subject;
   if(!empty($uid))
$vars['uid'] = $uid;
   if(!empty($message))

   $vars['message'] = $message;
   //$vars['uid'] = 1;

   if(!empty($response))
   $vars['response'] = $response;

   if(!empty($note))
  $vars['note'] = $note;

   if(!empty($assignId))
$vars['assignId'] = $assignId;

   if(!empty($deptId))
$vars['deptId']=$deptId;

   if(!empty($topicId))
   $vars['topicId'] = $topicId;

$vars['forms'] = array();
   $errors = array();
global $cfg;
$ticket_id = $data['ticket_id'];
//$vars['ticket_id'] = $ticket_id;     
$ticket = Ticket::lookup($ticket_id);
if(!$ticket)
{
 return json_encode(['msg' => "Ticket Not found", 'status' => $status]);
}
   if($ticket->update($vars,$errors))
	  {
    $status = true;
    $resp = "Success";
    }
    else 
    {
       // print_r($errors);

    ob_start();
print_r($errors);
$resp = ob_get_contents();;
ob_end_clean();
flush();
$status = false;

    }
    return json_encode(['msg' => $resp, 'status' => $status]);

}





function createstaff($data)
{
/* Required Parameters - username,email,dept_id,role_id */

if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}

  if(!isset($data['username']) || !isset($data['email']) || !isset($data['role_id']) || !isset($data['dept_id']))
{
 return json_encode(['msg' => "username,email,role_id and dept_id are required parameters", 'status' => false]);
}

 $role_id = $data['role_id'];
 
if(!Role::lookup($role_id)){
 return json_encode(['msg' => "Role Not found", 'status' => false]);
}   
    
$dept_id = $data['dept_id'];
if(!Dept::lookup($dept_id)){
 return json_encode(['msg' => "Dept Not found", 'status' => false]);
}   


   $vars = array();

$username = $data['username'];
$email = $data['email'];

$firstname = $data['firstname'];
$lastname = $data['lastname'];
$passwd = $data['passwd'];
$timezone = $data['timezone'];
$signature = $data['signature'];
$dept_id = $data['dept_id'];
$role_id = $data['role_id'];

if(!empty($data['islocked']) && $data['islocked'] == 1)
{
$vars['islocked'] = 1;
}

if(!empty($data['onvacation']) && $data['onvacation'] == 1)
{
$vars['onvacation'] = 1;
}
if(!empty($data['isadmin']) && $data['isadmin'] == 1)
{
$vars['isadmin'] = 1;
}

if(!empty($data['isvisible']) && $data['isvisible'] == 1)
{
$vars['isvisible'] = 1;
}


if(!empty($data['assigned_only']) && $data['assigned_only'] == 1)
{
$vars['assigned_only'] = 1;
}

$lang = $data['lang'];
$timezone_dst = $data['timezone_dst'];
$backend = $data['backend'];
$phone = $data['phone'];
$phone_ext = $data['phone_ext'];
$mobile = $data['mobile'];
$notes = $data['notes'];
$dept_access = $data['dept_access'];
$dept_access_alerts = $data['dept_access_alerts'];
$dept_access_role = $data['dept_access_role'];
  //  global $thisstaff;
   // $thisstaff = StaffAuthenticationBackend::getUser($user_id);



if(!empty($dept_access))
{
$m2 = explode(",",$dept_access);

if(!empty($dept_access_alerts))
{
$m3 = explode(",",$dept_access_alerts);
if(count($m2) != count($m3))
{
 return json_encode(['msg' => "Both dept_access and dept_access alerts should have same length", 'status' => false]);

}
foreach($m3 as $m)
{
if($m != 0 && $m != 1)
{
 return json_encode(['msg' => "dept_access Alert should be 0 or 1", 'status' => false]);

}
}
}



if(!empty($dept_access_role))
{
$m5 = explode(",",$dept_access_role);
if(count($m2) != count($m5))
{
 return json_encode(['msg' => "Both dept_access and dept_access roles should have same length", 'status' => false]);

}
foreach($m5 as $m)
{
if(!Role::lookup($m))
{
 return json_encode(['msg' => "dept_access Role Not found", 'status' => false]);

}
}
}








foreach($m2 as $m)
{
if(!is_int((int)$m))
{

 return json_encode(['msg' => "dept_access Id should be Integer", 'status' => false]);

}
if(!Dept::lookup($m)){

 return json_encode(['msg' => "dept_access ".$m." not found", 'status' => false]);

}
}


$m4 = array();
$m6 = array();

foreach($m2 as $k => $v)
{
$m4[$v] = $m3[$k];
$m6[$v] = $m5[$k];

}


$vars['dept_access'] = $m2;
$vars['dept_access_alerts'] = $m4;
$vars['dept_access_role'] = $m6;

}



$teams = $data['teams'];
$team_alerts = $data['team_alerts'];
if(!empty($teams))
{
$m2 = explode(",",$teams);

if(!empty($team_alerts))
{
$m3 = explode(",",$team_alerts);
if(count($m2) != count($m3))
{
 return json_encode(['msg' => "Both team and team alerts should have same length", 'status' => false]);

}
foreach($m3 as $m)
{
if($m != 0 && $m != 1)
{
 return json_encode(['msg' => "team Alert should be 0 or 1", 'status' => false]);

}
}
}

foreach($m2 as $m)
{
if(!is_int((int)$m))
{

 return json_encode(['msg' => "team Id should be Integer", 'status' => false]);

}
if(!Team::lookup($m)){

 return json_encode(['msg' => "team ".$m." not found", 'status' => false]);

}
}


$m4 = array();
foreach($m2 as $k => $v)
{
$m4[$v] = $m3[$k];
}


$vars['teams'] = $m2;
$vars['team_alerts'] = $m4;

}




   $vars['email'] = $email;
   $vars['username'] = $username;
   $vars['firstname'] = $firstname;
   $vars['lastname'] = $lastname;
   $vars['passwd'] = $passwd;
   $vars['timezone'] = $timezone;
   $vars['signature'] = $signature;
   $vars['dept_id'] = $dept_id;
   $vars['role_id'] = $role_id;
   $vars['isactive'] = $isactive;
   $vars['lang'] = $lang;
   $vars['timezone_dst'] = $timezone_dst;
   $vars['backend'] = $backend;
   $vars['phone'] = $phone;
   $vars['phone_ext'] = $phone_ext;
   $vars['mobile'] = $mobile;
   $vars['notes'] = $notes;






$staff = Staff::create();
$errors = array();
if ($staff->update($vars, $errors)) {
  $status = true;
    $resp = $staff->ht['staff_id'];
}
else
{
ob_start();
  print_r($errors);
    
$resp = ob_get_contents();;
ob_end_clean();
flush();
    $status = false;
}
    return json_encode(['msg' => $resp, 'status' => $status]);

}



function updatestaff($data)
{
/* Required Parameters - username,email,dept_id,role_id */


  if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}

    
if(!isset($data['staff_id']))
{
 return json_encode(['msg' => "staff_id is required parameter", 'status' => false]);
}
    

$vars = array();

$username = $data['username'];
$email = $data['email'];

$firstname = $data['firstname'];
$lastname = $data['lastname'];
$passwd = $data['passwd'];
$timezone = $data['timezone'];
$signature = $data['signature'];
$dept_id = $data['dept_id'];
$role_id = $data['role_id'];

if(!empty($data['islocked']) && $data['islocked'] == 1)
{
$vars['islocked'] = 1;
}

if(!empty($data['onvacation']) && $data['onvacation'] == 1)
{
$vars['onvacation'] = 1;
}
if(!empty($data['isadmin']) && $data['isadmin'] == 1)
{
$vars['isadmin'] = 1;
}

if(!empty($data['isvisible']) && $data['isvisible'] == 1)
{
$vars['isvisible'] = 1;
}


if(!empty($data['assigned_only']) && $data['assigned_only'] == 1)
{
$vars['assigned_only'] = 1;
}

$lang = $data['lang'];
$timezone_dst = $data['timezone_dst'];
$backend = $data['backend'];
$phone = $data['phone'];
$phone_ext = $data['phone_ext'];
$mobile = $data['mobile'];
$notes = $data['notes'];
$dept_access = $data['dept_access'];
$dept_access_alerts = $data['dept_access_alerts'];
$dept_access_role = $data['dept_access_role'];
  //  global $thisstaff;
   // $thisstaff = StaffAuthenticationBackend::getUser($user_id);

if(!empty($dept_access) && $dept_access == "*")
{
$vars['dept_access'] = array();
$vars['dept_access_alerts'] = array();
$vars['dept_access_role'] = array();

}
else
{
if(!empty($dept_access))
{
$m2 = explode(",",$dept_access);

if(!empty($dept_access_alerts))
{
$m3 = explode(",",$dept_access_alerts);
if(count($m2) != count($m3))
{
 return json_encode(['msg' => "Both dept_access and dept_access alerts should have same length", 'status' => false]);

}
foreach($m3 as $m)
{
if($m != 0 && $m != 1)
{
 return json_encode(['msg' => "dept_access Alert should be 0 or 1", 'status' => false]);

}
}
}



if(!empty($dept_access_role))
{
$m5 = explode(",",$dept_access_role);
if(count($m2) != count($m5))
{
 return json_encode(['msg' => "Both dept_access and dept_access roles should have same length", 'status' => false]);

}
foreach($m5 as $m)
{
if(!Role::lookup($m))
{
 return json_encode(['msg' => "dept_access Role Not found", 'status' => false]);

}
}
}








foreach($m2 as $m)
{
if(!is_int((int)$m))
{

 return json_encode(['msg' => "dept_access Id should be Integer", 'status' => false]);

}
if(!Dept::lookup($m)){

 return json_encode(['msg' => "dept_access ".$m." not found", 'status' => false]);

}
}


$m4 = array();
$m6 = array();

foreach($m2 as $k => $v)
{
$m4[$v] = $m3[$k];
$m6[$v] = $m5[$k];

}


$vars['dept_access'] = $m2;
$vars['dept_access_alerts'] = $m4;
$vars['dept_access_role'] = $m6;

}

}




$teams = $data['teams'];
$team_alerts = $data['team_alerts'];

if(!empty($teams) && $teams == "*")
{
$vars['teams'] = array();
$vars['team_alerts'] = array();

}
else
{

if(!empty($teams))
{
$m2 = explode(",",$teams);

if(!empty($team_alerts))
{
$m3 = explode(",",$team_alerts);
if(count($m2) != count($m3))
{
 return json_encode(['msg' => "Both team and team alerts should have same length", 'status' => false]);

}
foreach($m3 as $m)
{
if($m != 0 && $m != 1)
{
 return json_encode(['msg' => "team Alert should be 0 or 1", 'status' => false]);

}
}
}

foreach($m2 as $m)
{
if(!is_int((int)$m))
{

 return json_encode(['msg' => "team Id should be Integer", 'status' => false]);

}
if(!Team::lookup($m)){

 return json_encode(['msg' => "team ".$m." not found", 'status' => false]);

}
}


$m4 = array();
foreach($m2 as $k => $v)
{
$m4[$v] = $m3[$k];
}


$vars['teams'] = $m2;
$vars['team_alerts'] = $m4;

}
}



   $vars['email'] = $email;
   $vars['username'] = $username;
   $vars['firstname'] = $firstname;
   $vars['lastname'] = $lastname;
   $vars['passwd'] = $passwd;
   $vars['timezone'] = $timezone;
   $vars['signature'] = $signature;
   $vars['dept_id'] = $dept_id;
   $vars['role_id'] = $role_id;
   $vars['isactive'] = $isactive;
   $vars['lang'] = $lang;
   $vars['timezone_dst'] = $timezone_dst;
   $vars['backend'] = $backend;
   $vars['phone'] = $phone;
   $vars['phone_ext'] = $phone_ext;
   $vars['mobile'] = $mobile;
   $vars['notes'] = $notes;




$id = $data['staff_id'];
$vars['id'] = $id;
$staff = Staff::lookup($id);

if(empty($vars['username']))
{
$vars['username'] = $staff->ht['username'];
}
if(empty($vars['email']))
{
$vars['email'] = $staff->ht['email'];
}
if(empty($vars['firstname']))
{
$vars['firstname'] = $staff->ht['firstname'];
}
if(empty($vars['lastname']))
{
$vars['lastname'] = $staff->ht['lastname'];
}
if(empty($vars['dept_id']))
{
$vars['dept_id'] = $staff->ht['dept_id'];
}
if(empty($vars['role_id']))
{
$vars['role_id'] = $staff->ht['role_id'];
}

$role_id = $vars['role_id'];
 
if(!Role::lookup($role_id)){
 return json_encode(['msg' => "Role Not found", 'status' => false]);
}   
    
$dept_id = $vars['dept_id'];
if(!Dept::lookup($dept_id)){
 return json_encode(['msg' => "Dept Not found", 'status' => false]);
}   


$errors = array();
if ($staff->update($vars, $errors)) {
  $status = true;
    $resp = "Success";
}
else
{
ob_start();
  print_r($errors);
    
$resp = ob_get_contents();;
ob_end_clean();
flush();
    $status = false;
}
    return json_encode(['msg' => $resp, 'status' => $status]);

}



function createteam($data)
{
/* Required parameters - name */
    if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}

if(!isset($data['name']))
{
 return json_encode(['msg' => "name is required parameter", 'status' => false]);
}


$name = $data['name'];
$notes = $data['notes'];
$isenabled = $data['isenabled'];
$lead_id = $data['lead_id'];
$noalerts = $data['noalerts'];
$members = $data['members'];
$member_alerts = $data['member_alerts'];

$vars = array();
if(!empty($members))
{
$m2 = explode(",",$members);

if(!empty($member_alerts))
{
$m3 = explode(",",$member_alerts);
if(count($m2) != count($m3))
{
 return json_encode(['msg' => "Both members and member alerts should have same length", 'status' => false]);

}
foreach($m3 as $m)
{
if($m != 0 && $m != 1)
{
 return json_encode(['msg' => "Member Alert should be 0 or 1", 'status' => false]);

}
}
}

foreach($m2 as $m)
{
if(!is_int((int)$m))
{

 return json_encode(['msg' => "Member Id should be Integer", 'status' => false]);

}
if(!Staff::lookup($m)){

 return json_encode(['msg' => "Member ".$m." not found", 'status' => false]);

}
}


$m4 = array();
foreach($m2 as $k => $v)
{
$m4[$v] = $m3[$k];
}


$vars['members'] = $m2;
$vars['member_alerts'] = $m4;

}



if($lead_id && !Staff::lookup($lead_id)){
 return json_encode(['msg' => "Lead Person Not found", 'status' => false]);
} 

  //  global $thisstaff;
   // $thisstaff = StaffAuthenticationBackend::getUser($user_id);

   
   $vars['name'] = $name;
   $vars['notes'] = $notes;
   $vars['isenabled'] = $isenabled;
   $vars['lead_id'] = $lead_id;
   $vars['noalerts'] = $noalerts;




$team = Team::create();
$errors = array();
if ($team->update($vars, $errors)) {
  $status = true;

    $resp = $team->ht['team_id'];
}
else
{
ob_start();
       print_r($errors);
    
$resp = ob_get_contents();;
ob_end_clean();
flush();
    $status = false;
}
    return json_encode(['msg' => $resp, 'status' => $status]);



}


function updateteam($data)
{
/* Required parameters - name */
    if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}


if(!isset($data['team_id']))
{
 return json_encode(['msg' => "team_id is required parameter", 'status' => false]);
}

$name = $data['name'];
$team_id = $data['team_id'];
$notes = $data['notes'];
$isenabled = $data['isenabled'];
$lead_id = $data['lead_id'];
$noalerts = $data['noalerts'];
$members = $data['members'];
$member_alerts = $data['member_alerts'];


  //  global $thisstaff;
   // $thisstaff = StaffAuthenticationBackend::getUser($user_id);


$vars = array();




if(!empty($member) && $members == "*")
{
/*Special parameter to remove all members*/
$vars['members'] = array();
$vars['member_alerts'] = array();
}
else
{




if(!empty($members))
{
$m2 = explode(",",$members);

if(!empty($member_alerts))
{
$m3 = explode(",",$member_alerts);
if(count($m2) != count($m3))
{
 return json_encode(['msg' => "Both members and member alerts should have same length", 'status' => false]);

}
foreach($m3 as $m)
{
if($m != 0 && $m != 1)
{
 return json_encode(['msg' => "Member Alert should be 0 or 1", 'status' => false]);

}
}
}

foreach($m2 as $m)
{
if(!is_int((int)$m))
{

 return json_encode(['msg' => "Member Id should be Integer", 'status' => false]);

}
if(!Staff::lookup($m)){

 return json_encode(['msg' => "Member ".$m." not found", 'status' => false]);

}
}


$m4 = array();
foreach($m2 as $k => $v)
{
$m4[$v] = $m3[$k];
}


$vars['members'] = $m2;
$vars['member_alerts'] = $m4;

}

}

if($lead_id && !Staff::lookup($lead_id)){
 return json_encode(['msg' => "Lead Person Not found", 'status' => false]);
} 

  //  global $thisstaff;
   // $thisstaff = StaffAuthenticationBackend::getUser($user_id);

   $vars['id'] = $team_id;
   $vars['name'] = $name;
   $vars['notes'] = $notes;
   $vars['isenabled'] = $isenabled;
   $vars['lead_id'] = $lead_id;
   $vars['noalerts'] = $noalerts;






$team = Team::lookup($team_id);
print_r($vars);
$errors = array();
if ($team->update($vars, $errors)) {
  $status = true;
    $resp = "Success";
}
else
{
ob_start();
       print_r($errors);
    
$resp = ob_get_contents();;
ob_end_clean();
flush();
    $status = false;
}
    return json_encode(['msg' => $resp, 'status' => $status]);



}




function createdept($data)
{

/* Required Parameters - name,email */
  if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}

if(!isset($data['name']))
{
 return json_encode(['msg' => "name is required parameter", 'status' => false]);
}
if(!isset($data['email']))
{
 return json_encode(['msg' => "email is required parameter", 'status' => false]);
}


$name = $data['name'];
$email = $data['email'];

$phone = $data['phone'];
$signature = $data['signature'];
$ispublic = $data['ispublic'];
$autoresp_email_id = $data['autoresp_email_id'];
$manager_id = $data['manager_id'];
$tpl_id = $data['tpl_id'];
$sla_id = $data['sla_id'];
$schedule_id = $data['schedule_id'];
$pid = $data['pid'];
$status = $data['status'];
$email_id = $data['email_id'];
$flags = $data['flags'];
$assign_members_only = $data['assign_members_only'];
$disable_auto_claim = $data['disable_auto_claim'];
$disable_reopen_auto_assign = $data['disable_reopen_auto_assign'];
$ticket_auto_response = $data['ticket_auto_response'];
$message_auto_response = $data['message_auto_response'];
$group_membership = $data['group_membership'];
$members = $data['members'];
$member_alerts = $data['member_alerts'];
$member_role = $data['member_role'];










  //  global $thisstaff;
   // $thisstaff = StaffAuthenticationBackend::getUser($user_id);

   $vars = array();






if(!empty($members))
{
$m2 = explode(",",$members);

if(!empty($member_alerts))
{
$m3 = explode(",",$member_alerts);
if(count($m2) != count($m3))
{
 return json_encode(['msg' => "Both members and member alerts should have same length", 'status' => false]);

}
foreach($m3 as $m)
{
if($m != 0 && $m != 1)
{
 return json_encode(['msg' => "Member Alert should be 0 or 1", 'status' => false]);

}
}
}



if(!empty($member_role))
{
$m5 = explode(",",$member_role);
if(count($m2) != count($m5))
{
 return json_encode(['msg' => "Both members and member roles should have same length", 'status' => false]);

}
foreach($m5 as $m)
{
if(!Role::lookup($m))
{
 return json_encode(['msg' => "Member Role Not found", 'status' => false]);

}
}
}








foreach($m2 as $m)
{
if(!is_int((int)$m))
{

 return json_encode(['msg' => "Member Id should be Integer", 'status' => false]);

}
if(!Staff::lookup($m)){

 return json_encode(['msg' => "Member ".$m." not found", 'status' => false]);

}
}


$m4 = array();
$m6 = array();

foreach($m2 as $k => $v)
{
$m4[$v] = $m3[$k];
$m6[$v] = $m5[$k];

}


$vars['members'] = $m2;
$vars['member_alerts'] = $m4;
$vars['member_role'] = $m6;

}









$vars['email'] = $email;
   $vars['name'] = $name;
   $vars['phone'] = $phone;
   $vars['signature'] = $signature;
   $vars['ispublic'] = $ispublic;
   $vars['autoresp_email_id'] = $autoresp_email_id;
   $vars['manager_id'] = $manager_id;
   $vars['tpl_id'] = $tpl_id;
   $vars['sla_id'] = $sla_id;
   $vars['schedule_id'] = $schedule_id;
   $vars['pid'] = $pid;
   $vars['status'] = $status;
   $vars['email_id'] = $email_id;
   $vars['flags'] = $flags;
	$vars['group_membership'] = $group_membership;


if(!empty($assign_members_only) && $assign_members_only==1)
 $vars['assign_members_only'] = $assign_members_only;


if(!empty($disable_auto_claim) && $disable_auto_claim==1)
 $vars['disable_auto_claim'] = $disable_auto_claim;


if(!empty($disable_reopen_auto_assign) && $disable_reopen_auto_assign==1)
 $vars['disable_reopen_auto_assign'] = $disable_reopen_auto_assign;


if(!empty($ticket_auto_response) && $ticket_auto_response=1)
 $vars['ticket_auto_response'] = $ticket_auto_response;


if(!empty($message_auto_response) && $message_auto_response==1)
 $vars['message_auto_response'] = $message_auto_response;
  


if(!empty($email_id) && !Email::lookup($email_id)){
 return json_encode(['msg' => "Email Not found", 'status' => false]);
}   
if(!empty($autoresp_email_id) && !Email::lookup($autoresp_email_id)){
 return json_encode(['msg' => "Autorespond Email Not found", 'status' => false]);
} 
if(!empty($sla_id) && !SLA::lookup($sla_id)){
 return json_encode(['msg' => "SLA Not found", 'status' => false]);
}   
if(!empty($tpl_id) && !EmailTemplateGroup::lookup($tpl_id)){
 return json_encode(['msg' => "Email Template Group Not found", 'status' => false]);
} 

if(!empty($schedule_id) && !Schedule::lookup($schedule_id)){
 return json_encode(['msg' => "Schedule Not found", 'status' => false]);
} 
if(!empty($manager_id) && !Staff::lookup($manager_id)){
 return json_encode(['msg' => "Manager Not found", 'status' => false]);
} 
if(!empty($pid) && !Dept::lookup($pid)){
 return json_encode(['msg' => "Parent Dept Not found", 'status' => false]);
} 

if($status && $status != "active" && $status != "disabled" && $status !="archived")
{
 return json_encode(['msg' => "status can be active,disabled or archived", 'status' => false]);

}
if($group_membership && $group_membership != 0 && $group_membership != 1 && $group_membership !=2 && $group_membership != 3)
{
 return json_encode(['msg' => "group_membership can be 0,1,2,3", 'status' => false]);

}

$dept = Dept::create();
$errors = array();
if ($dept->update($vars, $errors)) {
  $status = true;
 $resp = $dept->ht['id'];
/*
 Create Email and Link 
*/
/*
$vars2= array();
$vars2['dept_id'] = $resp;
$vars2['name'] = $email_name;
$vars2['email'] = $email;
$vars2['priority_id'] = 2;
                 
$em = Email::create($vars2);

*/

   
}
else
{
ob_start();
print_r($errors);
$resp = ob_get_contents();;
ob_end_clean();
flush();
$status = false;
}
    return json_encode(['msg' => $resp, 'status' => $status]);



}



function updatedept($data)
{

/* Required Parameters - name,email */

if(!isset($data['token']))
{
 return json_encode(['msg' => "token is required", 'status' => false]);
}
if(TOKEN != $data['token'])
{
 return json_encode(['msg' => "token is Invalid", 'status' => false]);

}



if(!isset($data['dept_id']))
{
 return json_encode(['msg' => "dept_id is required parameter", 'status' => false]);
}

$dept_id = $data['dept_id'];

$name = $data['name'];
$email = $data['email'];

$phone = $data['phone'];
$signature = $data['signature'];
$ispublic = $data['ispublic'];
$autoresp_email_id = $data['autoresp_email_id'];
$manager_id = $data['manager_id'];
$tpl_id = $data['tpl_id'];
$sla_id = $data['sla_id'];
$schedule_id = $data['schedule_id'];
$pid = $data['pid'];
$status = $data['status'];
$email_id = $data['email_id'];
$flags = $data['flags'];
$assign_members_only = $data['assign_members_only'];
$disable_auto_claim = $data['disable_auto_claim'];
$disable_reopen_auto_assign = $data['disable_reopen_auto_assign'];
$ticket_auto_response = $data['ticket_auto_response'];
$message_auto_response = $data['message_auto_response'];
$group_membership = $data['group_membership'];


$members = $data['members'];
$member_alerts = $data['member_alerts'];
$member_role = $data['member_role'];



  //  global $thisstaff;
   // $thisstaff = StaffAuthenticationBackend::getUser($user_id);

  $vars = array();






if(!empty($members) && $members == "*")
{
/*Special parameter to remove all members*/
$vars['members'] = array();
$vars['member_role'] = array();
$vars['member_alerts'] = array();
}
else
{




if(!empty($members))
{
$m2 = explode(",",$members);

if(!empty($member_alerts))
{
$m3 = explode(",",$member_alerts);
if(count($m2) != count($m3))
{
 return json_encode(['msg' => "Both members and member alerts should have same length", 'status' => false]);

}
foreach($m3 as $m)
{
if($m != 0 && $m != 1)
{
 return json_encode(['msg' => "Member Alert should be 0 or 1", 'status' => false]);

}
}
}



if(!empty($member_role))
{
$m5 = explode(",",$member_role);
if(count($m2) != count($m5))
{
 return json_encode(['msg' => "Both members and member roles should have same length", 'status' => false]);

}
foreach($m5 as $m)
{
if(!Role::lookup($m))
{
 return json_encode(['msg' => "Member Role Not found", 'status' => false]);

}
}
}








foreach($m2 as $m)
{
if(!is_int((int)$m))
{

 return json_encode(['msg' => "Member Id should be Integer", 'status' => false]);

}
if(!Staff::lookup($m)){

 return json_encode(['msg' => "Member ".$m." not found", 'status' => false]);

}
}


$m4 = array();
$m6 = array();

foreach($m2 as $k => $v)
{
$m4[$v] = $m3[$k];
$m6[$v] = $m5[$k];

}


$vars['members'] = $m2;
$vars['member_alerts'] = $m4;
$vars['member_role'] = $m6;

}
}




$vars['id'] = $dept_id;
   $vars['email'] = $email;
   $vars['name'] = $name;
   $vars['phone'] = $phone;
   $vars['signature'] = $signature;
   $vars['ispublic'] = $ispublic;
   $vars['autoresp_email_id'] = $autoresp_email_id;
   $vars['manager_id'] = $manager_id;
   $vars['tpl_id'] = $tpl_id;
   $vars['sla_id'] = $sla_id;
   $vars['schedule_id'] = $schedule_id;
   $vars['pid'] = $pid;
   $vars['status'] = $status;
   $vars['email_id'] = $email_id;
   $vars['flags'] = $flags;
	$vars['group_membership'] = $group_membership;
if(!empty($assign_members_only) && $assign_members_only==1)
 $vars['assign_members_only'] = $assign_members_only;


if(!empty($disable_auto_claim) && $disable_auto_claim==1)
 $vars['disable_auto_claim'] = $disable_auto_claim;


if(!empty($disable_reopen_auto_assign) && $disable_reopen_auto_assign==1)
 $vars['disable_reopen_auto_assign'] = $disable_reopen_auto_assign;


if(!empty($ticket_auto_response) && $ticket_auto_response=1)
 $vars['ticket_auto_response'] = $ticket_auto_response;


if(!empty($message_auto_response) && $message_auto_response==1)
 $vars['message_auto_response'] = $message_auto_response;
  


if(!empty($email_id) && !Email::lookup($email_id)){
 return json_encode(['msg' => "Email Not found", 'status' => false]);
}   
if(!empty($autoresp_email_id) && !Email::lookup($autoresp_email_id)){
 return json_encode(['msg' => "Autorespond Email Not found", 'status' => false]);
} 
if(!empty($sla_id) && !SLA::lookup($sla_id)){
 return json_encode(['msg' => "SLA Not found", 'status' => false]);
}   
if(!empty($tpl_id) && !EmailTemplateGroup::lookup($tpl_id)){
 return json_encode(['msg' => "Email Template Group Not found", 'status' => false]);
} 

if(!empty($schedule_id) && !Schedule::lookup($schedule_id)){
 return json_encode(['msg' => "Schedule Not found", 'status' => false]);
} 
if(!empty($manager_id) && !Staff::lookup($manager_id)){
 return json_encode(['msg' => "Manager Not found", 'status' => false]);
} 
if(!empty($pid) && !Dept::lookup($pid)){
 return json_encode(['msg' => "Parent Dept Not found", 'status' => false]);
} 

if($status && $status != "active" && $status != "disabled" && $status !="archived")
{
 return json_encode(['msg' => "status can be active,disabled or archived", 'status' => false]);

}
if($group_membership && $group_membership != 0 && $group_membership != 1 && $group_membership !=2 && $group_membership != 3)
{
 return json_encode(['msg' => "group_membership can be 0,1,2,3", 'status' => false]);

}










$dept = Dept::lookup($dept_id);
if(!$dept)
{
    return json_encode(['msg' =>"Department not found", 'status' => $status]);

}
$errors = array();
if ($dept->update($vars, $errors)) {
  $status = true;
    $resp = "Success";
}
else
{
ob_start();

print_r($errors);
$resp = ob_get_contents();;
ob_end_clean();
flush();
$status = false;
}
    return json_encode(['msg' => $resp, 'status' => $status]);




}


?>